//=============================================================================
// WeaponKarkianBump.
//=============================================================================
class WeaponSuicideBomb extends WeaponNPCMelee;

var float BlastTime;
var bool bLit;

function Fire(float A)
{
 PlaySound(Sound'LAMSelect');
 
 AccurateRange = 80;
 MaxRange = 80;
 bLit = True;
}

//Protip: you die from suicide attacks

function ExplodeOwner()
{
 if (Owner == None) return;
 
 HurtRadius(250, 128, 'Exploded', 1, Owner.Location);
 HurtRadius(100, 64, 'Exploded', 1, Owner.Location);
 SpawnExplosionEffects(Owner.Location);
 PlaySound(sound'LAMExplode');
 Owner.TakeDamage(9999, None, Owner.Location, vect(0,0,0), 'Exploded');
 
 Destroy();
}

function SpawnExplosionEffects(Vector HitLocation)
{

	local ShockRing ring;
	local SphereEffect sphere;
	local ExplosionLight light;
	local AnimatedSprite expeffect;
	local Vector hitNormal;
	local float BlastRadius;
	
	BlastRadius = 256;
	
	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
   if (light != None)
      light.RemoteRole = ROLE_None;

	expeffect = Spawn(class'ExplosionMedium',,, HitLocation);
	light.size = 4;

   if (expeffect != None)
      expeffect.RemoteRole = ROLE_None;

	// draw a pretty shock ring
   	// For nano defense we are doing something else.

      ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
}

function Tick(float D)
{
 Super.Tick(D);
 
 if (bLit)
 {
  BlastTime -= D;
  
  if (BlastTime < 0)
  {
   ExplodeOwner();
   BlastTime = 9999;
  }
 }
}

defaultproperties
{
     ShotTime=0.100000
     HitDamage=0
     maxRange=512
     AccurateRange=512
     BaseAccuracy=0.000000
     AITimeLimit=10.000000
     AIFireDelay=8.000000
     BlastTime=3.000000

     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAM'
     PickupViewMesh=LodMesh'DeusExItems.LAMPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAM3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconLAM'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAM'
}
